/*
 * DesignProblem.cpp
 *
 *  Created on: Apr 20, 2012
 *      Author: linh, UC Davis
 */

#include <fstream>
#include "DesignProblem.h"

DesignProblem::DesignProblem() {

}

DesignProblem::DesignProblem(string filename) {
	std::ifstream f;
	f.open(filename.c_str());
	if (!f.good()) {
		cout << "Can not open file: " << filename << endl;
		return;
	}
	Init(&f);
	f.close();
}

DesignProblem::DesignProblem(const DesignProblem& another_design_problem) {
	gcg = another_design_problem.gcg;
	inputs = another_design_problem.inputs;
	outputs = another_design_problem.outputs;
}

DesignProblem::DesignProblem(istream* f) {
	Init(f);
}

DesignProblem& DesignProblem::operator = (const DesignProblem& another_design_problem) {
	gcg = another_design_problem.gcg;
	inputs = another_design_problem.inputs;
	outputs = another_design_problem.outputs;
	return *this;
}

void DesignProblem::Init(istream *f) {
	gcg.Init(f);
	string comments;
	*f >> comments;
	int number_of_conditions;
	*f >> number_of_conditions;
	inputs.resize(number_of_conditions);
	outputs.resize(number_of_conditions);
	for (int cond = 0; cond < number_of_conditions; cond++) {
		inputs[cond].resize(gcg.getNumberOfInputs());
		outputs[cond].resize(gcg.getNumberOfOutputs());
		for (int i = 0; i < gcg.getNumberOfInputs(); i++)
			*f >> inputs[cond][i];
		for (int i = 0; i < gcg.getNumberOfOutputs(); i++)
			*f >> outputs[cond][i];
	}
}

void DesignProblem::TestPrint(ostream* f){
	gcg.TestPrint(f);
	for (unsigned int cond = 0; cond < inputs.size(); cond++) {
		for (int i = 0; i < gcg.getNumberOfInputs(); i++)
			*f << inputs[cond][i] << "\t";
		for (int i = 0; i < gcg.getNumberOfOutputs(); i++)
			*f << outputs[cond][i] << "\t";
		*f << endl;
	}
}
